<?php
	require_once("startup.php");
	require_once("classes/dboperations.class.php");
	require_once("sphinxapi.inc");
	
	
	function getHomePageBestOfCompanies()
	{
		$SearchSQL1 = CountryToSearch();
		$SearchSQL = explode('|',$SearchSQL1);
		
		$EliteCityQuery = $SearchSQL[0];
		$CityQuery = $SearchSQL[1];
		
		$fields = " a.companyid,companyname,rating,eliteuserfilepath,eliteconfirmed, add1,add2,add3,arealandmark ";
		$fields1 = " companyid,companyname,rating,eliteuserfilepath,eliteconfirmed, add1,add2,add3,arealandmark ";
		//$restaurant = groupid= 515;
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid inner join mstproduct c on b.productid=c.productid where c.groupid= 515 and companyname like '%restaurant%' and $CityQuery  group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		//echo $sql; 
		$restaurant = FormatBestOfCompaniesData(returnData($sql),'restaurant','restauraunt_icon.jpg');
		
		//	$coffee shop = productid = 2468,688
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid where (b.productid='2468' or b.productid='688') and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$coffeeshop = FormatBestOfCompaniesData(returnData($sql),'coffee shop','Coffee_icon.jpg');
		
		//$hotel = 458;
		$sql = "select $fields1 from mstcompany where b2ccategoryid=458 and $CityQuery order by EliteConfirmed desc,eliteuserfilepath desc,rating desc";
		$hotels = FormatBestOfCompaniesData(returnData($sql),'hotel','hotel_icon.jpg');
		
		//$night club  = 703
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid where (b.productid='703') and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$nightclubs = FormatBestOfCompaniesData(returnData($sql),'night clubs','night_club_icon.jpg');
		
		//$shopping center = 903
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid where b.productid='903' and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$shoppingcenters = FormatBestOfCompaniesData(returnData($sql),'shopping centers','shopping_icon.jpg');
		
		//$grocery = b2ccategoryid = 2706
		$sql = "select $fields1 from mstcompany where companyname like '%grocery%' and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$grocery = FormatBestOfCompaniesData(returnData($sql),'grocery shops','grocery_icon.jpg');
		
		//$beaty salon = productid = 1381
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid where (b.productid='1381') and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$beautysalons = FormatBestOfCompaniesData(returnData($sql),'beauty salons','beauty_salon_icon.jpg');
		
		
		//$car rental = productid = 81
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid where (b.productid='81') and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$carrental = FormatBestOfCompaniesData(returnData($sql),'car rental','rent_car_icon.jpg');
		
		//$automobile = groupid = 380
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid where (b.productid='380') and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$automobile = FormatBestOfCompaniesData(returnData($sql),'automobile','autmobile_icon.jpg');
		
		//$school = groupid = 552
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid where activities like '%school%' and companyname like '%school%' and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$school = FormatBestOfCompaniesData(returnData($sql),'school','Colleges-icon.jpg');
		
		//$clinics =	$groupid = 428
		$sql = "select $fields from mstcompany a inner join trncompanyprod b on a.companyid=b.companyid inner join mstproduct c on b.productid=c.productid where c.groupid= 428 and companyname like '%clinic%' and $CityQuery group by companyname order by EliteConfirmed desc,eliteuserfilepath desc,rating desc ";
		$clinic = FormatBestOfCompaniesData(returnData($sql),'clinic','clinics_icon.jpg');
		
		
		return $restaurant.$coffeeshop.$hotels.$nightclubs.$shoppingcenters.$grocery.$beautysalons.$carrental.$automobile.$school.$clinic;
		//return $restaurant;
	}		 
		
		
	function FormatBestOfCompaniesData($dataArray,$CategoryHeading,$categoryIcon)
	{
		$CategoryHeadingWOSpace = str_replace(' ','',$CategoryHeading);
		if (is_array($dataArray))
		{
			$strFormatData = '<div id="'.$CategoryHeadingWOSpace.'" class="show-result_new">'."\n";
			$strFormatData .=  '<h4>'.ProperCase($categoryHeading).'</h4>'."\n";
			$strFormatData .=  '<div class="col-md-12">'."\n";
			$count = (count($dataArray)>8)?8:count($dataArray);
		    for ($i=0;$i<$count;$i++)
				{
			 		$companyname = ProperCase($dataArray[$i]['companyname']);
					$companyid	 = $dataArray[$i]['companyid'];
					$companylink = '<a href="'.DOC_ROOT.'companies/'.cleanURL($companyname).'-'.$companyid.'.htm" target="_blank" title=" View '.$companyname.' Profile ">'.$companyname.'</a>';
					$link		 = '<a href="'.DOC_ROOT.'companies/'.cleanURL($companyname).'-'.$companyid.'.htm" target="_blank" title=" View '.$companyname.' Profile ">';
					$rating 	 = $dataArray[$i]['rating'];
				
					$strFormatData .='<div class="col-md-6" style="height:100px">'."\n";
			 		if ($dataArray[$i]['eliteuserfilepath']!='')
					{
						$imagePath1 = $dataArray[$i]['eliteuserfilepath'];
						if (strpos($imagePath1,'th-')===false)
							{
								$imagePath = COMPANY_LOGO_DIR.'th-'.$imagePath1;
							}
							else
							{
								$imagePath = COMPANY_LOGO_DIR.$imagePath1;
							}
						$imagePathClass =  'class="homepageicons col-md-5"';	
					}
					else
					{
						//$imagePath = LOCAL_IMAGE_DIR.$categoryIcon;
						$imagePath = '';
						$imagePathClass =  "class='".$CategoryHeadingWOSpace."-image col-md-5'";
					}
					if ($dataArray[$i]['arealandmark ']!='')
						{
							$address = $dataArray[$i]['arealandmark '];	
						}
					
					$strFormatData .=	'<div '.$imagePathClass.' >'."\n";
					$strFormatData .=	$link;
					if ($imagePath !='')
					{
						$strFormatData .='	<img src="'.$imagePath.'" border="0" /></a>'."\n";
					}
					$strFormatData .=	'</div>'."\n";
			 		$strFormatData .=	'<div class="col-md-7"><h4>'.$companylink.'</h4>'."\n";
					$strFormatData .=	'<div class="rateit" data-rateit-value="'.$rating.'" data-rateit-ispreset="true" data-rateit-readonly="true"></div></div>'."\n";
					//<span>108 Reviews</span>
					$strFormatData .='</div>'."\n";
				}
			$strFormatData .='</div>'."\n";
			$strFormatData .='</div>'."\n";
		}
		return $strFormatData;
	}
	function returnDataSphinx($sql)
	{
		$connection = mysql_connect("207.58.165.119:9306") or die ("Couldn't connect to server.");
		$QryUser = mysql_query($sql);
		$TotalRows = mysql_num_rows($QryUser);
		 
			if ($TotalRows != 0)
			{
				$i=0;
				while ($companylist = mysql_fetch_assoc($QryUser))
					{
    					$compstr[] = $companylist;
					}
				//{
				//	$compstr[] = $companylist;
				//}
			}
			else
			{
				$compstr ='';
			}
		//print_r($compstr);	
		return 	$compstr;
	}
	function returnData($sql)
	{
		$retData ='';
		$latestcomps = new CommonProc();
		if ($sql!='')
		{	
			$retData = $latestcomps->getResults('',$sql);
		}
		unset($latestcomps);
		return $retData;
	}
	
	function CountryToSearch()
	{
		switch (strtoupper(COUNTRY_NAME))
		{
			case strtoupper("kuwait"):
				$EliteCityQuery = " (Countryid ='".COUNTRY_ID."' or GCCElite='1')";
				$cityQuery = " Countryid ='".COUNTRY_ID."' ";
				break;
			case strtoupper("bahrain"):
				$EliteCityQuery = " (Countryid ='".COUNTRY_ID."' or GCCElite='1')";
				$cityQuery = " Countryid ='".COUNTRY_ID."' ";
				break;	
			case strtoupper("Oman"):
				$EliteCityQuery = " (Countryid ='".COUNTRY_ID."' or GCCElite='1')";
				$cityQuery = " Countryid ='".COUNTRY_ID."' ";
				break;
			case strtoupper("saudi arabia"):
				$EliteCityQuery = " (Countryid ='".COUNTRY_ID."' or GCCElite='1')";
				$cityQuery = " Countryid ='".COUNTRY_ID."' ";
				break;
			case strtoupper("Qatar"):
				$EliteCityQuery = " (Countryid ='".COUNTRY_ID."' or GCCElite='1')";
				$cityQuery = " Countryid ='".COUNTRY_ID."' ";
				break;		
			case strtoupper("United arab Emirates"):
				if (strtoupper(CITY_NAME) != strtoupper("United Arab Emirates"))
				{
					$EliteCityQuery = " (cityid ='".CITY_ID."' or GCCElite='1' or AllUAEElite='1')";
					$cityQuery = " cityid ='".CITY_ID."'";
				}
				else
				{
					$EliteCityQuery = " (Countryid ='".COUNTRY_ID."' or GCCElite='1' or AllUAEElite='1')";
					$cityQuery = " Countryid ='".COUNTRY_ID."' ";	
				}	
				break;
			case strtoupper("UAE"):
				if (strtoupper(CITY_NAME) != strtoupper("UAE"))
				{
					$EliteCityQuery = " (cityid ='".CITY_ID."' or GCCElite='1' or AllUAEElite='1')";
					$cityQuery = " cityid ='".CITY_ID."'";
				}
				else
				{
					$EliteCityQuery = " (Countryid ='".COUNTRY_ID."' or GCCElite='1' or AllUAEElite='1')";
					$cityQuery = " Countryid ='".COUNTRY_ID."' ";	
				}	
				break;	
			default:
				$EliteCityQuery = " (Countryid ='1' or GCCElite='1')";
				$cityQuery = " Countryid ='1'";
				break;
		} // end of switch
		return $EliteCityQuery.'|'.$cityQuery;
	}
	setlocale(LC_ALL, 'en_US.UTF8');
	function cleanURL($str, $replace=array(), $delimiter='-') {
		if( !empty($replace) ) {
	  		$str = str_replace((array)$replace, ' ', $str);
	 	}
		
	 	$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
	 	$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
	 	$clean = strtolower(trim($clean, '-'));
	 	$clean = preg_replace("/[\/|+ -]+/", $delimiter, $clean);
	
	 	return $clean;
	}
	function getBuyOffersForHomePage($maingroupid='')
	{
		if ($maingroupid!='')
		{
			$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.offerdate, b.usercountry, b.usercityname 
FROM mstoffers a , mstusers b, mstproduct c WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND c.maingroupid='$maingroupid' and a.offerbyuserid = b.userid and a.selectedproductid= c.productid ORDER BY offerdate DESC limit 0,30 ";
			$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.offerdate, b.usercountry, b.usercityname FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC limit 0,30 ";
		}
		else
		{
		$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.offerdate, b.usercountry, b.usercityname FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC limit 0,30 ";
		}
		$eventlisting = returnData($sql);
		$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				$buyoffers = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{				
					$buyoffers .= '<li><div class="sellbuyoffer"><span>';
					$offertitle = ($eventlisting[$i]['OfferTitle']!='')?preview_text($eventlisting[$i]['OfferTitle'],30):preview_text($eventlisting[$i]['OfferDesc'],30);
					$buyoffers .= '<a href="'.DOC_ROOT.'b2b/'.$eventlisting[$i]['OfferID'].'/showoffers.htm">'.$offertitle.'</a></span> ';
					//$buyoffers .= '<br ><span class="graytextsmall"><strong>'.$eventlisting[$i]['usercountry'].'</strong>&nbsp;'.formatdate($eventlisting[$i]['offerdate'],'d-M').'</span><br ><br ></div></li>';
					$buyoffers .= '<br><span class="graytextsmall"><strong>'.$eventlisting[$i]['usercountry'].'</strong>&nbsp;</span><br><br></div></li>';
				}
			}
			else
			{
				$buyoffers = 'No Buy Offers found.';
			}
		}
	return $buyoffers;
	}
	function getSellOffersForHomePage($maingroupid='')
	{
		if ($maingroupid!='')
		{
			$sql	= "SELECT max(a.OfferID) as OfferID, a.OfferTitle, a.OfferDesc, date(a.offerdate) as offerdate, b.usercountry, b.usercityname, PicturePath FROM mstoffers a inner join mstusers b on a.offerbyuserid = b.userid inner join mstproduct c on a.productid=c.productid WHERE a.OfferType='1' and a.offerdontshow = '0' AND a.offerApproved ='1' and c.maingroupid='$maingroupid' group by a.OfferTitle, a.OfferDesc, DATE(a.offerdate), b.usercountry, b.usercityname ORDER BY offerdate DESC limit 0,30"; 

			$sql1	= "SELECT max(a.OfferID) as OfferID, a.OfferTitle, a.OfferDesc, date(a.offerdate) as offerdate, b.usercountry, b.usercityname, PicturePath FROM mstoffers a right join mstusers b on a.offerbyuserid = b.userid WHERE a.OfferType='1' and a.offerdontshow = '0' AND a.offerApproved ='1' group by a.OfferTitle, a.OfferDesc, DATE(a.offerdate), b.usercountry, b.usercityname ORDER BY offerdate DESC limit 0,30";
		}
		else
		{
			$sql	= "SELECT max(a.OfferID) as OfferID, a.OfferTitle, a.OfferDesc, date(a.offerdate) as offerdate, b.usercountry, b.usercityname, PicturePath FROM mstoffers a right join mstusers b on a.offerbyuserid = b.userid WHERE a.OfferType='1' and a.offerdontshow = '0' AND a.offerApproved ='1' group by a.OfferTitle, a.OfferDesc, DATE(a.offerdate), b.usercountry, b.usercityname ORDER BY offerdate DESC limit 0,30";
		}
		$eventlisting = returnData($sql);
		$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				$selloffers = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{	
			/*
			<li>
				<div class="sellbuyoffer"> <span class="offertopimage"><img src="images/1.png" height="40" width="40"/></span> <span><a href="#" class="mailseclinks">Lorem ipsum dolor ...20 june</a></span> </div>
            </li>			
			*/		
					$offertitle = ($eventlisting[$i]['OfferTitle']!='')?preview_text(strip_tags($eventlisting[$i]['OfferTitle']),30):preview_text(strip_tags($eventlisting[$i]['OfferDesc'],30));
					$sellofferlink = DOC_ROOT.'b2b/'.$eventlisting[$i]['OfferID'].'/showoffers.htm';
					
					$selloffers .= '<li><div class="sellbuyoffer"> <span class="offertopimage">';
					if ($eventlisting[$i]['PicturePath']!='') {
						$selloffers .= '<a href="'.$sellofferlink.'"><img class="lazy" data-original="'.COMPANY_PRODUCT_DIR.'thumb/'.$eventlisting[$i]['PicturePath'].'" alt="'.$offertitle.'" border="0" ></a>';
					}
					$selloffers .= '</span>';
					$selloffers .= '<a class="mailseclinks" href="'.DOC_ROOT.'b2b/'.$eventlisting[$i]['OfferID'].'/showoffers.htm">'.$offertitle.'</a>';
					$selloffers .= '<br ><span class="graytextsmall"><strong>'.$eventlisting[$i]['usercountry'].'</strong>&nbsp;'.formatdate($eventlisting[$i]['offerdate'],'d M').'</span><br ><br ></div></li>';
				}
			}
			else
			{
				$selloffers = 'No Buy Offers found.';
			}
		}
	return $selloffers;
	}
	function getProductsForHomePage($maingroupid='')
	{
		$todaysdate = date("Y-m-d");
		$lastmonth = date("Y-m-d H:i:s",mktime(0, 0, 0, date("m")-1, date("d"),   date("Y")));
		$limit = ' limit 0,24';
		if ($maingroupid!='')
		{
			$sql = "Select compprod, producttitle, productdesc, productimagefilepath,b.companyid from (Select max(CompanyProdID) as compprod from trncompanyprod where productimagefilepath > '' group by companyid) as a inner join trncompanyprod b on a.compprod = b.companyprodid inner join mstproduct c on b.productid=c.productid where c.maingroupid='$maingroupid' order by compprod desc $limit";
			$sql1 = "Select compprod, producttitle, productdesc, productimagefilepath,b.companyid from (Select max(CompanyProdID) as compprod from trncompanyprod where productimagefilepath > '' and (productentereddate between '$lastmonth' and '$todaysdate'  or productlastmodifieddate between '$lastmonth' and '$todaysdate') group by companyid) as a inner join trncompanyprod b on a.compprod = b.companyprodid order by compprod desc $limit";
			//echo $sql;
		}
		else
		{
			$sql = "Select compprod, producttitle, productdesc, productimagefilepath,b.companyid from (Select max(CompanyProdID) as compprod from trncompanyprod where productimagefilepath > '' and (productentereddate between '$lastmonth' and '$todaysdate'  or productlastmodifieddate between '$lastmonth' and '$todaysdate') group by companyid) as a inner join trncompanyprod b on a.compprod = b.companyprodid order by compprod desc $limit";	
		}	

		$eventlisting = returnData($sql);
		$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				$productonoffer = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{	
			/*
			<li>
				<div class="sellbuyoffer"> <span class="offertopimage"><img src="images/1.png" height="40" width="40"/></span> <span><a href="#" class="mailseclinks">Lorem ipsum dolor ...20 june</a></span> </div>
            </li>			
			*/		
					$productonoffer .= '<li><div class="sellbuyoffer"><span class="offertopimage">';
					
					$producttitle = preview_text(strip_tags($eventlisting[$i]['producttitle']),50);
					
					$CompanyProdID	  = $eventlisting[$i]['compprod'];	
					$productlink 	  = DOC_ROOT.'comprods/'.$CompanyProdID.'/'.str_replace('#45;','-',replaceForURL($producttitle)).'.htm';
					$productimagefilepath = strip_tags($eventlisting[$i]['productimagefilepath']);
					$productdesc		= str_replace('|','',preview_text(ProperCase(strip_tags(str_replace('|',' ',$eventlisting[$i]['productdesc']))),130));	
					
					$productonoffer .= '<a href="'.$productlink.'"><img src="'.COMPANY_PRODUCT_DIR.'thumb/'.$eventlisting[$i]['productimagefilepath'].'" alt="'.$producttitle.'" border="0" ></a></span>
					<span><a class="mailseclinks" href="'.$productlink.'">'.$producttitle.'</a></span><br ></div></li>';
				
					$EliteProductDetails .= '<div class="col-md-6">';
        			$EliteProductDetails .= '<h4><a href="'.$productlink.'">'.strtoupper($producttitle).'</a></h4>';
        			$EliteProductDetails .= '<a href="'.$productlink.'"><img src="'.COMPANY_PRODUCT_DIR.'thumb/'.$eventlisting[$i]['productimagefilepath'].'" alt="'.$producttitle.'" border="0" ></a>';
        			$EliteProductDetails .= '<p>'.$productdesc.'</p>';
        			//$EliteProductDetails .= '<p>Top height : 5.5-2-7cm</p>';
        			//$EliteProductDetails .= '<p>Min Order:200 Square Meters</p>';
      				$EliteProductDetails .= '</div>';
					
				}
			}
			else
			{
				$productonoffer = 'No Products found.';
			}
		}
	return $productonoffer.'~'.$EliteProductDetails;
	}
	
	function getMarketLeftMenu($maingroupid='',$maingroupnameurl='',$buyofferpage='0',$groupid=0)
	{
		if ($groupid > 0)
		{
			$sql = "Select productid,productname from mstproduct where groupid='$groupid' order by productname limit 0,500";
			$sql1 = "Select productid,productname from mstproduct where maingroupid='$maingroupid' order by productname limit 0,1000";
		}
		elseif ($maingroupid!='')
		{
			$sql = "Select productid,productname from mstproduct where maingroupid='$maingroupid' order by productname limit 0,1000";
		}
		else
		{
			$sql = "Select productid,productname,maingroupname,maingroupnameurl from mstproduct a inner join mstmaingroup b on a.maingroupid=b.maingroupid order by productname limit 0,200";
			$nomaingroupurl ='1';
		}

		$eventlisting = returnData($sql);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				$productlist = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{	
					$productname = cleanURL(replaceForURL($eventlisting[$i]['productname']));
					if ($nomaingroupurl=='1')
					{
						$maingroupnameurl = $eventlisting[$i]['maingroupnameurl'];
					}
					if (($buyofferpage!='0') && ($maingroupurl!=''))
					{
						$productlist .= '<li><a href="'.DOC_ROOT.$maingroupnameurl.'/buy/'.$productname.'.htm">'.strtoupper($eventlisting[$i]['productname']).'</a></li>';
					}
					else if (($maingroupnameurl!='')&&$maingroupnameurl!='b2b/')
					{
						if (COUNTRY_NAME=='Oman')
 						{ 						
							$productlist .= '<li><a href="'.DOC_ROOT.$maingroupnameurl.'/'.$productname.'-in-oman.htm">'.strtoupper($eventlisting[$i]['productname']).'</a></li>';
						}
						else 
						{
							$productlist .= '<li><a href="'.DOC_ROOT.$maingroupnameurl.'/'.$productname.'.htm">'.strtoupper($eventlisting[$i]['productname']).'</a></li>';							
						}		
					}
					else
					{
						$productlist .= '<li><a href="'.DOC_ROOT.'directory/'.$productname.'/'.$productname.'.htm">'.strtoupper($eventlisting[$i]['productname']).'</a></li>';
					}
				}
			}
			else
			{
				$productlist = '';
			}
		}
	return $productlist;
	}
	function getMainGroupDetailsFromProduct($productid='',$productname='')
	{
		$retVal ='';
		$fields = "maingroupid";
		if ($productid!='')
		{
			$sql = "Select $fields from mstproduct where productid='$productid'"; 
		}
		else if ($productname!='')
		{
			$sql = "Select $fields from mstproduct where productname='$productname'"; 
		}
		$eventlisting = returnData($sql);
		if ($eventlisting)
		{
			$maingroupid = $eventlisting[0]['maingroupid'];
			$retVal = getMainGroupDetails('',$maingroupid);
		}
		return $retVal;
	}
	
	function getMainGroupDetails($maingroupurl='',$maingroupid='',$maingroupname='')
	{
		$fields = "maingroupid,maingroupname,maingroupnameurl";
		if ($maingroupurl!='')
		{
			$sql = "Select $fields from mstmaingroup where maingroupnameurl='$maingroupurl'"; 
		}
		else if ($maingroupid!='')
		{
			$sql = "Select $fields from mstmaingroup where maingroupid='$maingroupid'";
		}
		else if ($maingroupname!='')
		{
			$sql = "Select $fields from mstmaingroup where maingroupname='$maingroupname'";
		}

		$eventlisting = returnData($sql);
		if ($eventlisting)
		{
			return 	$eventlisting;
		}
		else
		{
			return '';
		}	
	}
	function getMainGroupDropDown()
	{
		$fields = "maingroupid,maingroupname,maingroupnameurl";
		$sql = "Select $fields from mstmaingroup order by maingroupname ";
 		
		$eventlisting = returnData($sql);
		$productlist = '<ul class="dropdown-menu inbox-links" role="menu">';
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				
				for ($i=0;$i<$eventrowcount;$i++)
				{	
					$productname = cleanURL(replaceForURL($eventlisting[$i]['maingroupname']));
					$productlist .= '<li role="presentation"><a href="'.DOC_ROOT.$eventlisting[$i]['maingroupnameurl'].'-market/">'.$eventlisting[$i]['maingroupname'].' Marketplace</a></li>';
				}
				
			}
		}
		$productlist .= '</ul>';
	return $productlist;
	}
	function getEliteMembers($maingroupid='')
	{
		//and CityID = '".CITY_ID."'
		$currentdate = date("Y-m-d");
		if ($maingroupid!='')
		{
			$sql = "select a.companyid,companyname,eliteuserfilepath from mstcompany a inner join trncompanyprod b
on a.companyid=b.companyid inner join mstproduct c on b.productid=c.productid where isElite ='1' and EliteValidTillDate > '".$currentdate."' and eliteuserfilepath > '' and c.maingroupid='$maingroupid' group by eliteuserfilepath order by EliteEnteredDate desc limit 0,8 ";
			//echo $sql;
		}
		else
		{
			$sql = "select a.companyid,companyname,eliteuserfilepath from mstcompany where isElite ='1' and EliteValidTillDate > '".$currentdate."' and eliteuserfilepath > '' group by eliteuserfilepath order by EliteEnteredDate desc limit 0,8 ";
		}
		//$sql1 = "select companyid,companyname,eliteuserfilepath from mstcompany where isElite ='1' and EliteValidTillDate > '".date('Y\-m\-d')."' and eliteuserfilepath > '' group by eliteuserfilepath order by EliteValidTillDate  desc limit 0,8 ";
		$sql1 = "select companyid,companyname,eliteuserfilepath from mstcompany where 1=2";
		$eventlisting = returnData($sql);
		$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{	
			/*
				<li class="col-md-3">
					<a href="#"><img src="images/footer_logo1.jpg" />
        				<p>Jignesh Steel</p>
        			</a>
				</li>			
			*/		
					$companyName 	= $eventlisting[$i]['companyname'];
					$companyID		= $eventlisting[$i]['companyid'];
					
					$companyDetailsPath = "<a href='".DOC_ROOT."companies/".$companyID.".htm' class='bluedarkboldsmall' target='_new'>";
					
					$eShowRoomPath = "<a href='".DOC_ROOT."co-".replaceForURL($companyName)."/".$companyID."/' class='bluedarkboldsmall' target='_new'>View Our eShowRoom</a>";
					
					$LogoImage = '<img border="0" alt="View Details of '.$companyName.' " src="'.COMPANY_LOGO_DIR.'th-'.$eventlisting[$i]['eliteuserfilepath'].'">';
					
					$producttitle 	= ProperCase($eventlisting[$i]['producttitle']);
					
					$elitemembers .= '<li class="col-md-3">'.$companyDetailsPath.$LogoImage.'<p>'.$companyName.'</p></a></li>';
				}
			}
			else
			{
				$elitemembers = 'No Members found.';
			}
		}
		return $elitemembers;
	}
	function getBuyValuesName($byvaluetype='',$byvalueid='')
	{
		
		switch ($byvaluetype)
		{	case "needquote":
				$retval = ($byvalueid=='1')?' To Purchase':' A Quote';
				break;
			case "purchaseperiod":
				switch (intval($byvalueid))
						{
							case 0:
								$retval = 'Immediate Purchase';
								break;
							case 1:
								$retval = 'After 15 days to 1 month';
								break;
							default:
								$retval = 'Immediate Purchase';
								break;	
						}
					break;	
			case "supplierlocation":
				switch ($byvalueid)
						{
							case 0:
								$retval = 'Suppliers from '.CITY_NAME.' '.COUNTRY_NAME;
								break;
							case 1:
								$retval =  'Suppliers from Gulf';
								break;	
							case 1:
								$retval =  'Suppliers from Anywhere in World';
								break;
							default:
								$retval =  'Suppliers from Anywhere in World';
								break;			
						}
				break;			
		}
		return $retval;		
	}
	
	function getBuyOffers($maingroupid='',$maingroupurl='',$productid='',$productname='')
	{
		//$limits = ($limit =="")?" LIMIT 0,100":$limit;
		// Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid
		global $G_isElite;
		$limits = "limit 0,100";
		// removed GROUP BY offerdesc by rajiv on 20th feb 2015 
		if ($maingroupid!='')
		{
			//$sql = "SELECT * FROM gulf_buyoffers WHERE MATCH('@selectedproductid = ".$productid."') $limit";
			$sql = "SELECT a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b, mstproduct c 
WHERE c.maingroupid = '$maingroupid' and a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid 
and a.selectedproductid=c.productid  ORDER BY offerdate DESC ".$limits;
 
			$sql1 = "SELECT a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b
WHERE  a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC ".$limits;
			//echo $sql;
		}
		else if (($productid!="")&&($productname!=""))
		{
			$sql = "SELECT a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.selectedproductid = '".$productid."' and a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC ".$limits;
			$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND 	offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('".$productname."')> 5 or MATCH (a.offerdesc) AGAINST ('".$productname."')> 4) ORDER BY offerdate DESC ";

		}
		else if (($productid=="")&&($productname!=""))
		{
			//echo '1';
			$prodNameSearchString = replaceFromURL($productname);

			$searchStringArray = explode(' ',$prodNameSearchString);
			if (is_array($searchStringArray))
			{
				$count = count($searchStringArray);
			}
			if ($count > 4)
			{
				// more than 2 words
				$prodNameForSearch = '"'.replaceFromURL($prodNameSearchString).'"/0.5';
			}
			else
			{
				//two words phrase
				$prodNameForSearch = str_replace(' ','|',replaceFromURL($prodNameSearchString));

				//$prodNameForSearch = replaceFromURL($prodNameSearchString);
			}
			//echo $prodNameForSearch;
			$filter_words = array(" by "," from "," & "," of "," on "," to "," an "," a "," for "," in "," the "," with "," and "," not "," or "," same "," it "," we "," services "," wholesalers "," manufacturers "," whol ", " mfrs "," distr ",CITY_NAME," retail "," machine "," machinery ");
			//$less_valued_filter_words		  = array("high","thick","protection","accessories","tools","equipment","manufacturers","mfrs","suppliers","machine");
			$less_valued_filter_words_changed = ' ';
			$prodNameForSearch = str_replace($filter_words, $less_valued_filter_words_changed,replaceFromURL($prodNameSearchString));
			
			$prodNameS = str_replace($filter_words, $less_valued_filter_words_changed,replaceFromURL($prodNameForSearch));
			
			$prodNameForSearch = $prodNameS.'|"^'.$prodNameS.'$"|"^'.$prodNameS.'"|("'.$prodNameS.'")|"'.$prodNameS.'"/0.75';
	
			$OPTIONS = " OPTION ranker=expr('sum(lcs*user_weight)*1000+bm25') ";
			
			//$sql = "SELECT * FROM gulf_buyoffers WHERE MATCH('".$prodNameForSearch."') order by offerdate desc limit 1000 OPTION field_weights=(offertitle=20, offerdesc=10, max_matches=3000) ";
			
			//$sql = "SELECT * FROM gulf_buyoffers WHERE MATCH('@(offertitle)".$prodNameForSearch."') order by weight() DESC,offerdate DESC  limit 1000 $OPTIONS";
			//$sql = " SELECT * FROM gulf_buyoffers WHERE MATCH('@(offertitle)".$prodNameForSearch."') GROUP BY offerdate WITHIN GROUP ORDER BY weight() DESC order by offerdate desc";
			//echo $sql;
			//$eventlisting = returnDataSphinx($sql);
			//$eventrowcount = count($eventlisting);
			//$sql1 = "SELECT * FROM gulf_buyoffers WHERE MATCH('@(offerdesc)".$prodNameForSearch."') order by offerdate DESC,offerdate DESC limit 1000 $OPTIONS";
			//$sql1 = "SELECT * FROM gulf_buyoffers WHERE MATCH('@(offerdesc)".$prodNameForSearch."') GROUP BY offerid WITHIN GROUP ORDER BY offerdate DESC order by weight() desc";
			//echo $sql1;
			$sql = "SELECT a.OfferID as offerid, a.OfferTitle as offertitle, a.OfferDesc as offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and a.selectedproductid in (Select productid from mstproduct where productname ='".$productname."') ORDER BY offerdate DESC ";
			$eventlisting = returnData($sql);						
			$sql1 = "SELECT a.OfferID as offerid, a.OfferTitle as offertitle, a.OfferDesc as offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('+".$productname."' IN BOOLEAN MODE) or MATCH (a.offerdesc) AGAINST ('+".$productname."' IN BOOLEAN MODE)) ORDER BY offerdate DESC ";
		}
		else
		{
			$sql = "SELECT a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid GROUP BY offerbyuserid ORDER BY offerdate DESC ".$limits;
			$eventlisting = returnData($sql);
		}
		
		
		if (!$eventlisting)
		{
			$eventlisting = returnData($sql);
			$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		}
		
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				$strBuyOffer ='';
				for ($i=0;$i<$eventrowcount;$i++)
				{	
					$offerid	= $eventlisting[$i]['offerid'];
					$offertitle = $eventlisting[$i]['offertitle'];
					$offerdesc = Preview_text(convert_ascii(strip_tags($eventlisting[$i]['offerdesc'])),200);
					
					$offerlocation 	= $eventlisting[$i]['usercityname'].' '.$eventlisting[$i]['usercountry'];

					$offerlink		= DOC_ROOT.$maingroupurl.'-market/buy/'.cleanURL($offertitle).'-'.$offerid.'.htm';
					$offerdate		= formatdate($eventlisting[$i]['offerdate'],"d M Y");
					
					$need 			= getBuyValuesName('needquote',$eventlisting[$i]['needquote']);
					$wanttobuy		= getBuyValuesName('purchaseperiod',$eventlisting[$i]['purchaseperiod']);
					$preferredLoc	= getBuyValuesName('supplierlocation',$eventlisting[$i]['prefferedsupplierlocationid']);
					if ($eventlisting[$i]['Quantity']=='0')
					{
						$quantity 	= 'On Request';
					}
					else
					{
						$quantity		= $eventlisting[$i]['Quantity'].' '.$eventlisting[$i]['QuantityUnit'];
					}	
					
					//<a href="javascript:void(0);"><img src="'.LOCAL_IMAGE_DIR.'contectnow_btn.jpg" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal"></a>
					$userCompany =  "************";
					if ($G_isElite=='1')
					{
						//$userCompany =  $eventlisting[$i]['usercompany']>''?$eventlisting[$i]['usercompany']:$eventlisting[$i]['userfullname'];	
					}
					// add later on 
					// <span><strong>Preffered Location :</strong>'.$preferredLoc.'</span><br/>
					$strBuyOffer .= '<div class="col-md-12 tabs-main">
										<h4><a href="'.$offerlink.'">'.$offertitle.'</a></h4>'.$offerdesc.' 
			  								<br/>
											<div class="col-md-12 div-for-bg">
												<div class="col-md-12">
													<span><strong>Quantity : </strong><span style="color:red;">'.$quantity.'</span></span><br/>
													<span><strong>Need : </strong>'.$need.'</span><br/>
													<span><strong>Want to Buy : </strong>'.$wanttobuy.'</span><br/>
													<span><strong>Supplier from : </strong>'.$preferredLoc.'</span><br/>
												</div>
												<div class="col-md-9">
													<span><strong>Required By :'.$userCompany.', '.$offerlocation.'</strong><br/>'.$offerdate.'</span><br>
													<small>
													<a href="#" class="singleleadpurchase" data-toggle="modal" data-offerid="'.$offerid.'" data-offertitle="'.$offertitle.'" data-offerdesc="'.$offerdesc.'" data-qtytext="'.$quantity.'" data-purchaseperiod="'.$wanttobuy.'" data-preferredlocation="'.$preferredLoc.'" data-target="#BuySingleEnquiryModalgcc">													
														Want Buyer Details ? Get Now
													</a>
													</small> 
												</div>
												<div class="col-md-3">
													<a href="#OfferReply" data-toggle="modal" data-offertype="0" data-offerid="'.$offerid.'" class="openReply btn btn-primary btn-lg">
														<img src="'.IMAGE_DIR.'contectnow_btn.jpg">
													</a>
												</div>
			  								</div>
											<!--<a href="'.$offerlink.'">More.....</a>
			  								<div class="col-md-12 div-for-bg">
												
			  								</div>-->
										</div>';
				}	
			}		
		}
		return str_replace('|','',$strBuyOffer).'|'.$eventrowcount;	
	}
	function getBuyOffersForInbox($maingroupid='',$maingroupurl='',$productid='',$productname='')
	{
		//$limits = ($limit =="")?" LIMIT 0,100":$limit;
		// Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid
		global $G_isElite;
		$limits = "limit 0,1000";
		// removed GROUP BY offerdesc by rajiv on 20th feb 2015 
		if ($maingroupid!='')
		{
			//$sql = "SELECT * FROM gulf_buyoffers WHERE MATCH('@selectedproductid = ".$productid."') $limit";
			$sql = "SELECT a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b, mstproduct c 
WHERE c.maingroupid = '$maingroupid' and a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid 
and a.selectedproductid=c.productid  ORDER BY offerdate DESC ".$limits;
 
			$sql1 = "SELECT a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b
WHERE  a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC ".$limits;
			//echo $sql;
		}
		else if (($productid!="")&&($productname!=""))
		{
			$sql = "SELECT a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.selectedproductid = '".$productid."' and a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC ".$limits;
			$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND 	offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('".$productname."')> 5 or MATCH (a.offerdesc) AGAINST ('".$productname."')> 4) ORDER BY offerdate DESC ";

		}
		else if (($productid=="")&&($productname!=""))
		{
			$prodNameSearchString = replaceFromURL($productname);

			$searchStringArray = explode(' ',$prodNameSearchString);
			if (is_array($searchStringArray))
			{
				$count = count($searchStringArray);
			}
			if ($count > 4)
			{
				// more than 2 words
				$prodNameForSearch = '"'.replaceFromURL($prodNameSearchString).'"/0.5';
			}
			else
			{
				//two words phrase
				$prodNameForSearch = str_replace(' ','|',replaceFromURL($prodNameSearchString));
				//$prodNameForSearch = replaceFromURL($prodNameSearchString);
			}
			$sql = "SELECT * FROM gulf_buyoffers WHERE MATCH('".$prodNameForSearch."') order by offerdate desc limit 1000 OPTION field_weights=(offertitle=20, offerdesc=10, max_matches=3000) ";
			//echo $sql;
			$eventlisting = returnDataSphinx($sql);
			//$eventrowcount = count($eventlisting);
			
			//$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and a.selectedproductid in (Select productid from mstproduct where productname ='".$productname."') ORDER BY offerdate DESC ";
			//$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('+".$productname."' IN BOOLEAN MODE) or MATCH (a.offerdesc) AGAINST ('+".$productname."' IN BOOLEAN MODE)) ORDER BY offerdate DESC ";
		}
		else
		{
			$sql = "SELECT SQL_CALC_FOUND_ROWS a.offerid, a.offertitle, a.offerdesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid GROUP BY offerbyuserid ORDER BY offerdate DESC ".$limits;
		}
		
		if (!$eventlisting)
		{
			$eventlisting = returnData($sql);
			$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		}
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
		}
		return $eventlisting.'|'.$eventrowcount;	
	}
	
	
	function getBuyOffers_Org($maingroupid='',$maingroupurl='',$productid='',$productname='')
	{
		//$limits = ($limit =="")?" LIMIT 0,100":$limit;
		// Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid
		global $G_isElite;
		$limits = "Limit 0,100";
		// removed GROUP BY offerdesc by rajiv on 20th feb 2015 
		if ($maingroupid!='')
		{
			
			$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b, mstproduct c 
WHERE c.maingroupid = '$maingroupid' and a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid 
and a.selectedproductid=c.productid  ORDER BY offerdate DESC ".$limits;
 
			$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b
WHERE  a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC ".$limits;
		}
		else if (($productid!="")&&($productname!=""))
		{
			$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.selectedproductid = '".$productid."' and a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid ORDER BY offerdate DESC ".$limits;
			$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND 	offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('".$productname."')> 5 or MATCH (a.offerdesc) AGAINST ('".$productname."')> 4) ORDER BY offerdate DESC ";
		
		}
		else if (($productid=="")&&($productname!=""))
		{
			$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and a.selectedproductid in (Select productid from mstproduct where productname ='".$productname."') ORDER BY offerdate DESC ";
			$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('+".$productname."' IN BOOLEAN MODE) or MATCH (a.offerdesc) AGAINST ('+".$productname."' IN BOOLEAN MODE)) ORDER BY offerdate DESC ";
		}
		else
		{
			$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname, Quantity, QuantityUnit, AnnualQuantity, AnnualQuantityUnit, needquote,purchaseperiod,prefferedsupplierlocationid FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid GROUP BY offerbyuserid ORDER BY offerdate DESC ".$limits;
		}
		
		$eventlisting = returnData($sql);
		$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{	
					$offerid	= $eventlisting[$i]['OfferID'];
					$offertitle = $eventlisting[$i]['OfferTitle'];
					$offerdesc = Preview_text($eventlisting[$i]['OfferDesc'],100);
					
					$offerlocation 	= $eventlisting[$i]['usercityname'].' '.$eventlisting[$i]['usercountry'];

					$offerlink		= DOC_ROOT.$maingroupurl.'-market/buy/'.cleanURL($offertitle).'-'.$offerid.'.htm';
					
					$offerdate		= formatdate($eventlisting[$i]['offerdate'],"d M Y");
					
					$need 			= getBuyValuesName('needquote',$eventlisting[$i]['needquote']);
					$wanttobuy		= getBuyValuesName('purchaseperiod',$eventlisting[$i]['purchaseperiod']);
					$preferredLoc	= getBuyValuesName('supplierlocation',$eventlisting[$i]['prefferedsupplierlocationid']);
					
					//<a href="javascript:void(0);"><img src="'.LOCAL_IMAGE_DIR.'contectnow_btn.jpg" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal"></a>
					$userCompany =  "************";
					if ($G_isElite=='1')
					{
						$userCompany =  $eventlisting[$i]['usercompany']>''?$eventlisting[$i]['usercompany']:$eventlisting[$i]['userfullname'];	
					}
					// add later on 
					// <span><strong>Preffered Location :</strong>'.$preferredLoc.'</span><br/>
					$strBuyOffer .= '<div class="col-md-12 tabs-main">
										<h4><a href="'.$offerlink.'">'.$offertitle.'</a></h4>'.$offerdesc.' 
			  								<br/>
											<div class="col-md-12 div-for-bg">
												<div class="col-md-12">
													<span><strong>Need :</strong>'.$need.'</span><br/>
													<span><strong>Want to Buy :</strong>'.$wanttobuy.'</span><br/>
													
												</div>
			  								</div>
											<a href="'.$offerlink.'">More.....</a>
			  								<div class="col-md-12 div-for-bg">
												<div class="col-md-6">
													<span><strong>Required By :'.$userCompany.', '.$offerlocation.'</strong>&nbsp;&nbsp;&nbsp;'.$offerdate.'</span>
												</div>
												<div class="col-md-6">
													<a href="#OfferReply" data-toggle="modal" data-offertype="0" data-offerid="'.$offerid.'" class="openReply btn btn-primary btn-lg">
														<img src="'.IMAGE_DIR.'contectnow_btn.jpg"></a>
												</div>
			  								</div>
										</div>';
				}	
			}		
		}
		return $strBuyOffer.'|'.$eventrowcount;	
	}
	function getProductsWithPhotos($countryid='')
	{
		if ($countryid>0)
		{
			$sql = "Select companyprodid, producttitle,productname,groupname, productimagefilepath,b.companyid,price,pricecurrency,c.validforecommerce,productentereddate from trncompanyprod b 
			inner join mstproduct c on b.productid=c.productid
			inner join mstgroup e on c.groupid=e.groupid
			inner join mstcompany f on f.companyid=b.companyid
			where productimagefilepath > '' and f.countryid='$countryid' 
			group by companyid
			ORDER BY productentereddate desc, eliteconfirmed desc";
		}
		else {
		//$sql = "Select compprod, ProductName, producttitle, prodimagepath,compid,CompanyName,cityname,productdesc,productentereddate,productlastmodifieddate,prodid,maingroupurl from ( Select companyprodid as compprod, ProductName, producttitle, productdesc, productimagefilepath as prodimagepath, max(a.companyid) as compid,CompanyName,cityname,productentereddate,productlastmodifieddate,b.productid as prodid,maingroupnameurl as maingroupurl from trncompanyprod b inner join mstproduct c on b.productid=c.productid inner join mstcompany a on a.companyid=b.companyid inner join mstcity d on a.cityid=d.cityid left join mstmaingroup e on c.maingroupid=e.maingroupid where (a.countryid='".COUNTRY_ID."' or GCCElite='1') and productimagefilepath > '' and isElite='1' and EliteConfirmed='1' and EliteValidTillDate > '$todaysdate' group by a.companyid) as der ORDER BY productentereddate Desc,productlastmodifieddate DESC ".$limits;
		$sql = "Select companyprodid, producttitle,productname,groupname, productimagefilepath,b.companyid,price,pricecurrency,c.validforecommerce,productentereddate from trncompanyprod b 
		inner join mstproduct c on b.productid=c.productid
		inner join mstgroup e on c.groupid=e.groupid
		inner join mstcompany f on f.companyid=b.companyid
		where productimagefilepath > '' 
		group by companyid
		ORDER BY productentereddate desc, eliteconfirmed desc";		
		}
		$eventlisting = returnData($sql);
		return $eventlisting;
	}
	function getLatestProducts($eventlisting,$limit=3)
	{
			if ((CITY_ID!='')&&(CITY_ID!=COUNTRY_ID))
			{	
				$countryid= " f.countryid='".CITY_ID."'";
			}
			else {
				$countryid= " f.countryid='".COUNTRY_ID."'";
			}		
				
			$sql = "Select companyprodid, producttitle,productname,groupname, productimagefilepath,b.companyid,price,pricecurrency,c.validforecommerce,productentereddate from trncompanyprod b 
			inner join mstproduct c on b.productid=c.productid
			inner join mstgroup e on c.groupid=e.groupid
			inner join mstcompany f on f.companyid=b.companyid
			where productimagefilepath > '' and ".$countryid."  
			group by companyid
			ORDER BY productentereddate desc, eliteconfirmed desc";
			$eventlisting = returnData($sql);
			$eventrowcount = count($eventlisting);
			if ($eventrowcount < 3)
			{
				$eventlisting = getProductsWithPhotos();
				$eventrowcount = count($eventlisting);
			}
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				$j=0;				
				for ($i=0;$i<$eventrowcount;$i++)
					{	
						if ($j>=$limit)
							{
								break;
							}						
						$offerid	= $eventlisting[$i]['companyprodid'];	
						//$offerdesc = str_replace('|',' ',strip_tags($eventlisting[$i]['productdesc']));
						$offertitlelong = $eventlisting[$i]['producttitle'];
						$offertitleshort = preview_text(Propercase(strtolower(str_replace('|',' ',$eventlisting[$i]['producttitle']))),30);
					
						//$offerlocation 		= Propercase(strtolower($eventlisting[$i]['cityname']));
						$offerlink			= $eventlisting[$i]['compprod'];
						//$offerdate			= formatdate($eventlisting[$i]['productentereddate'],"d M Y");
												
						$offerImage			= $eventlisting[$i]['productimagefilepath'];	
						//$usercompanyname 	= Propercase(strtolower($eventlisting[$i]['CompanyName']));
						$maingroupurl		= $eventlisting[$i]['maingroupurl'];
						$offerdetailLink	= DOC_ROOT.$maingroupurl.'-market/products/'.cleanURL($offertitlelong).'-'.$offerid.'.htm';
						$productid			= $eventlisting[$i]['prodid'];
						$companyid			= $eventlisting[$i]['compid'];
						$price 				= ($eventlisting[$i]['price']>0)?$eventlisting[$i]['pricecurrency'].' '.$eventlisting[$i]['price']:'ON REQUEST';
					
						if (file_exists(PRODUCT_IMAGE_PATH.$offerImage))
						{					
						$eliteProductsHomePage .= '<div class="col-md-3">
								<div class=" brand-img">
									<a href="'.$offerdetailLink.'" title="'.$offertitlelong.'">
										<img src="'.COMPANY_PRODUCT_DIR.$offerImage.'" title="'.$offertitlelong.'" alt="'.$offertitlelong.'">
									</a>
								</div>
							</div>';
					
						/* $eliteProductsHomePage .= '	<div class="col-md-3 col-sm-3 col-xs-6">
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="min-height:100px;border:0;width:100%;">
								<a href="'.$offerdetailLink.'"><img style="height:100%;width:100%;" class="img-responsive" src="'.COMPANY_PRODUCT_DIR.$offerImage.'" title="'.$offertitlelong.'" alt="'.$offertitlelong.'"></a>
							</div>
							<div class="clear-fix"></div>
							<div>
								<a href="'.$offerdetailLink.'" title="'.$offertitlelong.'"><button class="btn-danger" style="border-radius:40px;">'.$price.'</button></a>
							</div>							
							<div class="clear-fix"></div>							
							<div class="col-md-12 col-sm-12 hidden-xs">
								<h5><a href="'.$offerdetailLink.'" title="'.$offertitlelong.'">'.$offertitleshort.'</a></h5>
							</div>
						</div>';
						*/
							$j++;
						}							
							
					}		
			}
			return $eliteProductsHomePage;	
	}
	function getEliteProductsForHomePage($groupname='',$eventlisting,$limit=6)
	{
		//$limits = "Limit 0,$limit";
		/*
		
		$todaysdate = date("Y-m-d");
		
		$sql = "Select compprod, ProductName, producttitle, prodimagepath,compid,CompanyName,cityname,productdesc,productentereddate,productlastmodifieddate,prodid,maingroupurl from ( Select companyprodid as compprod, ProductName, producttitle, productdesc, productimagefilepath as prodimagepath, max(a.companyid) as compid,CompanyName,cityname,productentereddate,productlastmodifieddate,b.productid as prodid,maingroupnameurl as maingroupurl from trncompanyprod b inner join mstproduct c on b.productid=c.productid inner join mstcompany a on a.companyid=b.companyid inner join mstcity d on a.cityid=d.cityid left join mstmaingroup e on c.maingroupid=e.maingroupid where (a.countryid='".COUNTRY_ID."' or GCCElite='1') and productimagefilepath > '' and isElite='1' and EliteConfirmed='1' and EliteValidTillDate > '$todaysdate' group by a.companyid) as der ORDER BY productentereddate Desc,productlastmodifieddate DESC ".$limits;
		$eventlisting = returnData($sql);
		*/
				
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				$j=0;				
				for ($i=0;$i<$eventrowcount;$i++)
					{	
						if ($j>=$limit)
							{
								break;
							}						
						if ($groupname==$eventlisting[$i]['groupname'])
						{	
						$offerid	= $eventlisting[$i]['companyprodid'];	
						//$offerdesc = str_replace('|',' ',strip_tags($eventlisting[$i]['productdesc']));
						$offertitlelong = $eventlisting[$i]['producttitle'];
						$offertitleshort = preview_text(Propercase(strtolower(str_replace('|',' ',$eventlisting[$i]['producttitle']))),30);
					
						//$offerlocation 		= Propercase(strtolower($eventlisting[$i]['cityname']));
						$offerlink			= $eventlisting[$i]['compprod'];
						//$offerdate			= formatdate($eventlisting[$i]['productentereddate'],"d M Y");
						$offerImage			= $eventlisting[$i]['productimagefilepath'];	
						//$usercompanyname 	= Propercase(strtolower($eventlisting[$i]['CompanyName']));
						$maingroupurl		= $eventlisting[$i]['maingroupurl'];
						$offerdetailLink	= DOC_ROOT.$maingroupurl.'-market/products/'.cleanURL($offertitlelong).'-'.$offerid.'.htm';
						$productid			= $eventlisting[$i]['prodid'];
						$companyid			= $eventlisting[$i]['compid'];
						$price 				= ($eventlisting[$i]['price']>0)?$eventlisting[$i]['pricecurrency'].' '.$eventlisting[$i]['price']:'ON REQUEST';
					
						//<a href="'.$offerdetailLink.'"><img class="lazy" style="max-height:100%;max-width:100%;object-fit:cover" data-original="'.COMPANY_PRODUCT_DIR.'thumb/'.$offerImage.'" title="'.$offertitlelong.'"></a>
						$eliteProductsHomePage .= '	<div class="col-lg-2 col-md-2 col-sm-3 col-xs-6">
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="height:100px;border:0">
								<a href="'.$offerdetailLink.'"><img style="height:100%;width:100%;object-fit:cover" src="'.COMPANY_PRODUCT_DIR.'thumb/'.$offerImage.'" title="'.$offertitlelong.'" alt="'.$offertitlelong.'""></a>	
							</div>
							<div class="clear-fix"></div>
							<div>
								<a href="'.$offerdetailLink.'" title="'.$offertitlelong.'"><button class="btn-danger" style="width:125px;height:24px;border-radius:40px;">'.$price.'</button></a>
							</div>							
							<div class="clear-fix"></div>
							<div class="col-md-12 col-sm-12 col-xs-12">
								<h5><a href="'.$offerdetailLink.'" title="'.$offertitlelong.'">'.$offertitleshort.'</a></h5>
							</div>
						</div>';
							$j++;
													
						}	
					}		
			}
		}	
		return $eliteProductsHomePage;		
	}
	function getEliteProductsForMobileApp($groupname='',$eventlisting,$limit=6)
	{
		//$limits = "Limit 0,$limit";
		/*
		
		$todaysdate = date("Y-m-d");
		
		$sql = "Select compprod, ProductName, producttitle, prodimagepath,compid,CompanyName,cityname,productdesc,productentereddate,productlastmodifieddate,prodid,maingroupurl from ( Select companyprodid as compprod, ProductName, producttitle, productdesc, productimagefilepath as prodimagepath, max(a.companyid) as compid,CompanyName,cityname,productentereddate,productlastmodifieddate,b.productid as prodid,maingroupnameurl as maingroupurl from trncompanyprod b inner join mstproduct c on b.productid=c.productid inner join mstcompany a on a.companyid=b.companyid inner join mstcity d on a.cityid=d.cityid left join mstmaingroup e on c.maingroupid=e.maingroupid where (a.countryid='".COUNTRY_ID."' or GCCElite='1') and productimagefilepath > '' and isElite='1' and EliteConfirmed='1' and EliteValidTillDate > '$todaysdate' group by a.companyid) as der ORDER BY productentereddate Desc,productlastmodifieddate DESC ".$limits;
		$eventlisting = returnData($sql);
		*/
				
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				$j=0;
								
				for ($i=0;$i<$eventrowcount;$i++)
					{	
						if ($j>=$limit)
							{
								break;
							}						
						if ($groupname==$eventlisting[$i]['groupname'])
						{	
						
						$offerid	= $eventlisting[$i]['companyprodid'];	
						//$offerdesc = str_replace('|',' ',strip_tags($eventlisting[$i]['productdesc']));
						$offertitlelong = $eventlisting[$i]['producttitle'];
						$offertitleshort = preview_text(Propercase(strtolower(str_replace('|',' ',$eventlisting[$i]['producttitle']))),30);
					
						//$offerlocation 		= Propercase(strtolower($eventlisting[$i]['cityname']));
						$offerlink			= $eventlisting[$i]['compprod'];
						//$offerdate			= formatdate($eventlisting[$i]['productentereddate'],"d M Y");
						$offerImage			= $eventlisting[$i]['productimagefilepath'];	
						//$usercompanyname 	= Propercase(strtolower($eventlisting[$i]['CompanyName']));
						$maingroupurl		= $eventlisting[$i]['maingroupurl'];
						$offerdetailLink	= DOC_ROOT.$maingroupurl.'-market/products/'.cleanURL($offertitlelong).'-'.$offerid.'.htm';
						$productid			= $eventlisting[$i]['prodid'];
						$companyid			= $eventlisting[$i]['compid'];
						$price 				= ($eventlisting[$i]['price']>0)?$eventlisting[$i]['pricecurrency'].' '.$eventlisting[$i]['price']:'ON REQUEST';
						
						$jsoncompanyarray[] = array("CompanyProdID"=>$offerid,"productname"=>$offertitleshort,"productimage"=>COMPANY_PRODUCT_DIR.'thumb/'.$offerImage);
						$j++;
													
						}	
					}		
			}
		}	
		return $jsoncompanyarray;		
	}	
	
	function getEliteProducts($maingroupid='',$maingroupurl='',$productid='',$productname='')
	{
		//$limits = ($limit =="")?" LIMIT 0,100":$limit;
		$limits = "Limit 0,100";
		$todaysdate = date("Y-m-d");
		if ($maingroupid!='')
		{
			$sql = "Select compprod, ProductName, producttitle, prodimagepath,compid,CompanyName,cityname,productdesc,productentereddate,productlastmodifieddate,prodid from ( Select companyprodid as compprod, ProductName, producttitle, productdesc, productimagefilepath as prodimagepath, max(a.companyid) as compid,CompanyName,cityname,productentereddate,productlastmodifieddate,b.productid as prodid from trncompanyprod b inner join mstproduct c on b.productid=c.productid inner join mstcompany a on a.companyid=b.companyid inner join mstcity d on a.cityid=d.cityid where (a.countryid='".COUNTRY_ID."' or GCCElite='1') and productimagefilepath > '' and isElite='1' and EliteConfirmed='1' and EliteValidTillDate > '$todaysdate' and maingroupid='$maingroupid' group by a.companyid) as der ORDER BY productentereddate Desc,productlastmodifieddate DESC ".$limits;
			//echo  $sql;
	
			$sql1 = "Select compprod, ProductName, producttitle, prodimagepath,compid,CompanyName,cityname,productdesc,productentereddate,productlastmodifieddate,prodid from ( Select companyprodid as compprod, ProductName, producttitle, productdesc, productimagefilepath as prodimagepath, max(a.companyid) as compid,CompanyName,cityname,productentereddate,productlastmodifieddate,b.productid as prodid from trncompanyprod b inner join mstproduct c on b.productid=c.productid inner join mstcompany a on a.companyid=b.companyid inner join mstcity d on a.cityid=d.cityid where productimagefilepath > '' and isElite='1' and EliteConfirmed='1' and EliteValidTillDate > '$todaysdate' group by a.companyid) as der ORDER BY productentereddate Desc,productlastmodifieddate DESC ".$limits;
		}
		else if (($productid!="")&&($productname!=""))
		{
			//$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname FROM mstoffers a, mstusers b WHERE a.selectedproductid = '".$productid."' and a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid GROUP BY offerdesc ORDER BY offerdate DESC ".$limits;
			//$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND 	offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('".$productname."')> 5 or MATCH (a.offerdesc) AGAINST ('".$productname."')> 4) GROUP BY offerdesc ORDER BY offerdate DESC ";
		
		}
		else if (($productid=="")&&($productname!=""))
		{
			//$sql = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and a.selectedproductid in (Select productid from mstproduct where productname ='".$productname."') GROUP BY offerdesc ORDER BY offerdate DESC ";
			//$sql1 = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, a.recurringrequirement, b.usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname FROM mstoffers a, mstusers b WHERE a.OfferType='0' and a.offerdontshow = '0' AND a.offerApproved ='1' AND offerShowOnSite ='1' and a.offerbyuserid = b.userid and (MATCH (a.offertitle) AGAINST ('+".$productname."' IN BOOLEAN MODE) or MATCH (a.offerdesc) AGAINST ('+".$productname."' IN BOOLEAN MODE)) GROUP BY offerdesc ORDER BY offerdate DESC ";
		}
		
		$eventlisting = returnData($sql);
		$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{
					$offerid	= $eventlisting[$i]['compprod'];	
					$offertitle = str_replace('|',' ',$eventlisting[$i]['producttitle']);
					$offerdesc = str_replace('|',' ',strip_tags($eventlisting[$i]['productdesc']));
					
					$offerlocation 		= $eventlisting[$i]['cityname'];
					$offerlink			= $eventlisting[$i]['compprod'];
					$offerdate			= formatdate($eventlisting[$i]['productentereddate'],"d M Y");
					$offerImage			= $eventlisting[$i]['prodimagepath'];	
					$usercompanyname 	= $eventlisting[$i]['CompanyName'];
					$offerdetailLink	= DOC_ROOT.$maingroupurl.'-market/products/'.cleanURL($offertitle).'-'.$offerid.'.htm';
					$productid			= $eventlisting[$i]['prodid'];
					$companyid			= $eventlisting[$i]['compid'];
					// <img  src="'.COMPANY_PRODUCT_DIR.'thumb/'.$offerImage.'" title="'.$offertitle.'">
					
					
					$eliteProducts .= '	<div class="col-md-12"><h4><a href="'.$offerdetailLink.'">'.$offertitle.'</a></h4>
											<div class="col-md-3">
												<a href="'.$offerdetailLink.'">
													<img class="lazy" data-original="'.COMPANY_PRODUCT_DIR.'thumb/'.$offerImage.'" title="'.$offertitle.'">
												</a>
											</div>
											<div class="col-md-9 short-products">'.$offerdesc.'</div>
											<div class="col-md-12 div-for-bg">
			    								<div class="col-md-6">
													<span><strong>Supplier :</strong> '.$usercompanyname.' '.$offerlocation.' <br/><strong>Posted On :</strong>'.ago($offerdate).'</span>
												</div>
												<div class="col-md-6">
													<a href="#SendEnquiryModal" data-toggle="modal" data-productid="'.$productid.'" data-companyid="'.$companyid.'" data-productterm="'.$offertitle.'" class="openProductEnq btn btn-primary btn-lg"><img src="'.IMAGE_DIR.'contectnow_btn.jpg"></a>
												</div>
											</div>
											<div class="clear"></div>
										</div>';
				
				}
			}
		}
		return 	$eliteProducts.'|'.$eventrowcount;
	}
	function getSellOffers($maingroupid='',$maingroupurl='')
	{
		$limits = ($limit =="")?" LIMIT 0,100":$limit;
		
		if ($maingroupid!='')
		{
			$sql_prefix = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, PicturePath, a.recurringrequirement,  c.companyname as usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname FROM mstoffers a, mstusers b, mstcompany c, mstproduct d WHERE d.maingroupid='$maingroupid' and a.OfferType='1' and a.offerdontshow = '0' and PicturePath !='' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid and b.companyid=c.companyid and a.productid=d.productid ";
		}
		else
		{
			$sql_prefix = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, PicturePath, a.recurringrequirement,  c.companyname as usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname FROM mstoffers a, mstusers b, mstcompany c WHERE a.OfferType='1' and a.offerdontshow = '0' and PicturePath !='' AND a.offerApproved ='1' AND a.offerbyuserid = b.userid and b.companyid=c.companyid";
		}
		if (($productid!="")&&($productname!=""))
		{
			$sql = $sql_prefix." and a.productid = '".$productid."' ORDER BY offerdate DESC ".$limits;
			$sql1 = " and (MATCH (a.offertitle) AGAINST ('".$productname."')> 5 or MATCH (a.offerdesc) AGAINST ('".$productname."')> 4) ORDER BY offerdate DESC ";
		}
		else if (($productid=="")&&($productname!=""))
		{
			$sql = $sql_prefix." and a.productid in (Select productid from mstproduct where productname ='".$productname."') ORDER BY offerdate DESC ";
			$sql1 = $sql_prefix." and (MATCH (a.offertitle) AGAINST ('+".$productname."' IN BOOLEAN MODE) or MATCH (a.offerdesc) AGAINST ('+".$productname."' IN BOOLEAN MODE)) ORDER BY offerdate DESC ";
		}
		else
		{
			$sql = $sql_prefix." ORDER BY offerdate DESC ".$limits;
		}
		
		$eventlisting = returnData($sql);
		//$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{
					$offerid	= $eventlisting[$i]['OfferID'];	
					$offertitle = strip_tags(str_replace('|',' ',$eventlisting[$i]['OfferTitle']));
					$offerdesc 	= strip_tags(str_replace('|',' ',$eventlisting[$i]['OfferDesc']));
					
					$offerlocation 		= $eventlisting[$i]['usercityname'].' '.$eventlisting[$i]['usercountry'];
					$offerlink			= $eventlisting[$i]['OfferID'];
					$offerdate			= formatdate($eventlisting[$i]['offerdate'],"d M Y");
					$offerImage			= $eventlisting[$i]['PicturePath'];	
					$usercompanyname 	= $eventlisting[$i]['usercompany'];
					$offerdetailLink	= DOC_ROOT.$maingroupurl.'-market/sell/'.cleanURL($offertitle).'-'.$offerid.'.htm';

					// data-offertype='1' for sell offers and 0 for buy offers
					$Selloffers .= '<div class="col-md-12 tabs-main">
										<h4><a href="'.$offerdetailLink.'">'.$offertitle.'</a></h4>
										<div class="col-md-3">
											<a href="'.$offerdetailLink.'">
												<img class="lazy" data-original="'.COMPANY_PRODUCT_DIR.'thumb/'.$offerImage.'" title="'.$offertitle.'">
											</a>
										</div>
										<div class="col-md-9 short-products">'.(($offerdesc!='')?$offerdesc:"&nbsp;").'
										</div>
										<div class="col-md-12 div-for-bg">
			    							<div class="col-md-6">
												<span><strong>Supplier :</strong> '.$usercompanyname.'</span>
											</div>
											<div class="col-md-6">
												<a href="#SellReplyformbody" data-toggle="modal" data-offertype="1" data-offerid="'.$offerid.'" class="openReply btn btn-primary btn-lg">
														<img src="'.IMAGE_DIR.'contectnow_btn.jpg"></a>
											</div>
										</div>
										<div class="clear"></div>
									</div>';
				}
			}
		}
		return 	$Selloffers.'|'.$eventrowcount;
	}
	
	function PrepareEmail($pageTemplateName,$ValueArray)
	{
	
	}
	function debug_to_console($data) 
	{
    	if(is_array($data) || is_object($data))
		{
		echo("<script>console.log('PHP: ".json_encode($data)."');</script>");
		} else {
		echo("<script>console.log('PHP: ".$data."');</script>");
		}
	}
	function createURLForModal($urlType,$additionalParameters,$anchorText,$urlID)
	{
		switch ($urlType)
		{
			case "Enquiry":
				if ($urlID=='dropBuyOffer')
				{
					$strURL = "<a id='$urlID' class='btn btn-default openProductEnq' data-toggle='modal' $additionalParameters data-target='#SendEnquiryModal' href='javascript:void(0);'>$anchorText</a>";
				}
				else
				{
					$strURL = "<a id='$urlID' class='btn btn-default dropdown-toggle openProductEnq' data-toggle='modal' $additionalParameters data-target='#SendEnquiryModal' href='javascript:void(0);'>$anchorText</a>";		
				}	
				break;
			case "BuyOfferReply":
				$strURL = "<a id='$urlID' class='btn btn-default openProductEnq' data-toggle='modal' $additionalParameters data-target='#BuyOfferReplyModal' href='javascript:void(0);'>$anchorText</a>";
				break;
			case "SellOfferReply":
				$strURL = "<a id='$urlID' class='btn btn-default openProductEnq' data-toggle='modal' $additionalParameters data-target='#SellOfferReplyModal' href='javascript:void(0);'>$anchorText</a>";
				break;
			case "Map":
				//myModalMap
				$strURL = "<i class='icon ion-location btn btn-primary btn-lg' title='Location Map' data-target='#myModalMap' data-toggle='modal' style='font-size:24px; color:#333333;'></i>";
				break;
			case "ReportError":
				$strURL = "<i class='icon ion-compose btn btn-primary btn-lg' title='Location Map' data-target='#ReportError' data-toggle='modal' style='font-size:24px; color:#333333;'></i>";
				break;
			case "ReportShutDown":
				$strURL = "<i class='icon ion-close-circled btn btn-primary btn-lg' title='Report Shutdown' data-target='#ReportShutdwon' data-toggle='modal' style='font-size:24px; color:#333333;'></i>";
				break;
			case "ClaimListing":
				$strURL = "<i class='icon ion-flag btn btn-primary btn-lg' title='Claim Listing' data-target='#ClaimListing' data-toggle='modal' style='font-size:24px; color:#333333;'></i>";
				break;
			
		}
		return $strURL;
	}
	function getOtherSellOffers($currentOfferId,$companyid,$maingroupurl)
	{
		$sqlText = "SELECT a.OfferID, a.OfferTitle, a.OfferDesc, a.DeliveryDetails, a.offerdate, a.ExpiryDate, a.offerbyuserid, a.offerdontshow, a.Deleted, a.selectedproductid, a.searchproductterm, PicturePath, a.recurringrequirement,  c.companyname as usercompany, b.usercountry, b.usercityname,concat(b.usersalutation,' ',b.userfirstname,' ' ,b.userlastname) as userfullname FROM mstoffers a inner join mstusers b 
		on a.offerbyuserid = b.userid inner join mstcompany c on b.companyid=c.companyid inner join mstproduct d on a.productid=d.productid  WHERE a.OfferType='1' and a.offerdontshow = '0' and PicturePath !='' AND a.offerApproved ='1' and c.companyid='$companyid' ";
		//echo $sqlText;
		$eventlisting = returnData($sqlText);
		//$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
			if ($eventrowcount > 0)
			{
				//$productonoffer = '';
				for ($i=0;$i<$eventrowcount;$i++)
				{
					
					$offerid	= $eventlisting[$i]['OfferID'];	
					$offertitle = strip_tags(str_replace('|',' ',$eventlisting[$i]['OfferTitle']));
					$offerdesc 	= strip_tags(str_replace('|',' ',$eventlisting[$i]['OfferDesc']));
					
					$offerlocation 		= $eventlisting[$i]['usercityname'].' '.$eventlisting[$i]['usercountry'];
					$offerlink			= $eventlisting[$i]['OfferID'];
					$offerdate			= formatdate($eventlisting[$i]['offerdate'],"d M Y");
					$offerImage			= $eventlisting[$i]['PicturePath'];	
					$usercompanyname 	= $eventlisting[$i]['usercompany'];
					$offerdetailLink	= DOC_ROOT.$maingroupurl.'-market/sell/'.cleanURL($offertitle).'-'.$offerid.'.htm';
					
					if ($offerid!= $currentOfferId)
					{
						$otherselloffers .= '<li>
											<div class="company_products_image">
												<a href="'.$offerdetailLink.'">
													<img class="lazy" data-original="'.COMPANY_PRODUCT_DIR.'thumb/'.$offerImage.'" title="'.$offertitle.'">
												</a>
											</div>
											<a href="'.$offerdetailLink.'"><h6>'.$offertitle.'</h6></a>
											<div class="clear"></div>
										</li>';	
				
					}
				}
			}
		}
	return $otherselloffers;				
	}
	
	/* Ban certain IPs based on no of hits they give */
	/* consideration dont ban IPs from google, bing, yahoo, msn etc
	
	
	*/
	function isKnownBot()
	{
		
	}
	function IPCheck()
		{
			$ipad = $_SERVER['REMOTE_ADDR'];	// Collects the user/visitor IP address.
			$ban = "Deny from $ipad\n";			// What will be written to the .htaccess file if IP needs to be banned.
			$file = "banIP.src";					// Change to -> .htaccess <- once thoroughly tested. Should be placed in the root directory.
			$search = file_get_contents($file);		// Prepare the .htaccess file by gathering entire contents.
			$check = strpos($search, $ipad);		// Checks the .htaccess file if the current user IP address string does exist.
			
			// This next part of the script checks to see if the IP is already banned or not.
			// If the IP does not already exist; it will write the ban line to the .htaccess file, display the message, and then email you a copy.
			// If the IP is already listed in the .htaccess file; the script ends with only a displayed message.
			if ($check === FALSE) {
	
			$open = @fopen($file, "a");			// Open the .htaccess file and get ready for writing only.
			$write = @fputs($open, $ban);		// Write the banned IP line to the .htaccess file. (Example: Deny from 12.34.56.789)
	
			// Email a copy of ban and info to your admin account (or other email address).
			// Make sure you change the email address.
			@mail('BlOcK_IpS@YoUr_WeB_sItE.cOm','Banned IP '.$_SERVER['REMOTE_ADDR'].'','
			Banned IP: '.$_SERVER['REMOTE_ADDR'].'
			Request URI: '.$_SERVER['REQUEST_URI'].'
			User Agent: '.$_SERVER['HTTP_USER_AGENT']);
	
			// IP address is not banned - so there is a need to write to .htaccess file.
			// Display the error message to the user. (You may change to read what you want).
			echo '<html><head><title>IP Address '.$ipad.' - Blocked or Banned!</title></head><body bgcolor="#FF000000" text="#FFFFFF" oncontextmenu="return false;"><center><font face="Verdana, Arial"><h1>THANK YOU - DON\'T COME AGAIN!</h1><b>IP Address '.$ipad.' Has Been Blocked or Banned!<br />Contact the web admin if this ban is by mistake.<p />Have a nice day!</b></font></center></body></html>';
	
			// Close the .htaccess file - all done.
			@fclose($open);
	} else {
	
	// IP address is already banned - no need to rewrite to .htaccess file.
	// Display the error message to the user. (You may change to read what you want).
		echo '<html><head><title>IP Address '.$ipad.' - Blocked or Banned!</title></head><body bgcolor="#FF000000" text="#FFFFFF" oncontextmenu="return false;"><center><font face="Verdana, Arial"><h1>THANK YOU - DON\'T COME AGAIN!</h1><b>IP Address '.$ipad.' Has Been Blocked or Banned!<br />Contact the web admin if this ban is by mistake.<p />Have a nice day!</b></font></center></body></html>';
	}
	
	// End of File/Script;
		exit();
	}
	function getNewsForNewsHomePage($newsid='')
	{

		if ($newsid=='')
		{
			$sql = "Select * from mstnewsevents where isNews='1' order by eventstartdate desc";
		}
		else
		{
			$newseventsid = intval($newsid);
			$sql = "Select * from mstnewsevents where newsid='$newseventsid' ";

		}
		$eventlisting = returnData($sql);
		$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
		if ($eventlisting)
		{
			$eventrowcount = count($eventlisting);
		}
		return $eventlisting;
	}
	
// HTML Minifier
function minify_html($input) {
    if(trim($input) === "") return $input;
    // Remove extra white-space(s) between HTML attribute(s)
    $input = preg_replace_callback('#<([^\/\s<>!]+)(?:\s+([^<>]*?)\s*|\s*)(\/?)>#s', function($matches) {
        return '<' . $matches[1] . preg_replace('#([^\s=]+)(\=([\'"]?)(.*?)\3)?(\s+|$)#s', ' $1$2', $matches[2]) . $matches[3] . '>';
    }, str_replace("\r", "", $input));
    // Minify inline CSS declaration(s)
    if(strpos($input, ' style=') !== false) {
        $input = preg_replace_callback('#<([^<]+?)\s+style=([\'"])(.*?)\2(?=[\/\s>])#s', function($matches) {
            return '<' . $matches[1] . ' style=' . $matches[2] . minify_css($matches[3]) . $matches[2];
        }, $input);
    }
    return preg_replace(
        array(
            // t = text
            // o = tag open
            // c = tag close
            // Keep important white-space(s) after self-closing HTML tag(s)
            '#<(img|input)(>| .*?>)#s',
            // Remove a line break and two or more white-space(s) between tag(s)
            '#(<!--.*?-->)|(>)(?:\n*|\s{2,})(<)|^\s*|\s*$#s',
            '#(<!--.*?-->)|(?<!\>)\s+(<\/.*?>)|(<[^\/]*?>)\s+(?!\<)#s', // t+c || o+t
            '#(<!--.*?-->)|(<[^\/]*?>)\s+(<[^\/]*?>)|(<\/.*?>)\s+(<\/.*?>)#s', // o+o || c+c
            '#(<!--.*?-->)|(<\/.*?>)\s+(\s)(?!\<)|(?<!\>)\s+(\s)(<[^\/]*?\/?>)|(<[^\/]*?\/?>)\s+(\s)(?!\<)#s', // c+t || t+o || o+t -- separated by long white-space(s)
            '#(<!--.*?-->)|(<[^\/]*?>)\s+(<\/.*?>)#s', // empty tag
            '#<(img|input)(>| .*?>)<\/\1>#s', // reset previous fix
            '#(&nbsp;)&nbsp;(?![<\s])#', // clean up ...
            '#(?<=\>)(&nbsp;)(?=\<)#', // --ibid
            // Remove HTML comment(s) except IE comment(s)
            '#\s*<!--(?!\[if\s).*?-->\s*|(?<!\>)\n+(?=\<[^!])#s'
        ),
        array(
            '<$1$2</$1>',
            '$1$2$3',
            '$1$2$3',
            '$1$2$3$4$5',
            '$1$2$3$4$5$6$7',
            '$1$2$3',
            '<$1$2',
            '$1 ',
            '$1',
            ""
        ),
    $input);
}
// CSS Minifier => http://ideone.com/Q5USEF + improvement(s)
function minify_css($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')|\/\*(?!\!)(?>.*?\*\/)|^\s*|\s*$#s',
            // Remove unused white-space(s)
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/))|\s*+;\s*+(})\s*+|\s*+([*$~^|]?+=|[{};,>~+]|\s*+-(?![0-9\.])|!important\b)\s*+|([[(:])\s++|\s++([])])|\s++(:)\s*+(?!(?>[^{}"\']++|"(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')*+{)|^\s++|\s++\z|(\s)\s+#si',
            // Replace `0(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)` with `0`
            '#(?<=[\s:])(0)(cm|em|ex|in|mm|pc|pt|px|vh|vw|%)#si',
            // Replace `:0 0 0 0` with `:0`
            '#:(0\s+0|0\s+0\s+0\s+0)(?=[;\}]|\!important)#i',
            // Replace `background-position:0` with `background-position:0 0`
            '#(background-position):0(?=[;\}])#si',
            // Replace `0.6` with `.6`, but only when preceded by `:`, `,`, `-` or a white-space
            '#(?<=[\s:,\-])0+\.(\d+)#s',
            // Minify string value
            '#(\/\*(?>.*?\*\/))|(?<!content\:)([\'"])([a-z_][a-z0-9\-_]*?)\2(?=[\s\{\}\];,])#si',
            '#(\/\*(?>.*?\*\/))|(\burl\()([\'"])([^\s]+?)\3(\))#si',
            // Minify HEX color code
            '#(?<=[\s:,\-]\#)([a-f0-6]+)\1([a-f0-6]+)\2([a-f0-6]+)\3#i',
            // Replace `(border|outline):none` with `(border|outline):0`
            '#(?<=[\{;])(border|outline):none(?=[;\}\!])#',
            // Remove empty selector(s)
            '#(\/\*(?>.*?\*\/))|(^|[\{\}])(?:[^\s\{\}]+)\{\}#s'
        ),
        array(
            '$1',
            '$1$2$3$4$5$6$7',
            '$1',
            ':0',
            '$1:0 0',
            '.$1',
            '$1$3',
            '$1$2$4$5',
            '$1$2$3',
            '$1:0',
            '$1$2'
        ),
    $input);
}
// JavaScript Minifier
function minify_js($input) {
    if(trim($input) === "") return $input;
    return preg_replace(
        array(
            // Remove comment(s)
            '#\s*("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\')\s*|\s*\/\*(?!\!|@cc_on)(?>[\s\S]*?\*\/)\s*|\s*(?<![\:\=])\/\/.*(?=[\n\r]|$)|^\s*|\s*$#',
            // Remove white-space(s) outside the string and regex
            '#("(?:[^"\\\]++|\\\.)*+"|\'(?:[^\'\\\\]++|\\\.)*+\'|\/\*(?>.*?\*\/)|\/(?!\/)[^\n\r]*?\/(?=[\s.,;]|[gimuy]|$))|\s*([!%&*\(\)\-=+\[\]\{\}|;:,.<>?\/])\s*#s',
            // Remove the last semicolon
            '#;+\}#',
            // Minify object attribute(s) except JSON attribute(s). From `{'foo':'bar'}` to `{foo:'bar'}`
            '#([\{,])([\'])(\d+|[a-z_][a-z0-9_]*)\2(?=\:)#i',
            // --ibid. From `foo['bar']` to `foo.bar`
            '#([a-z0-9_\)\]])\[([\'"])([a-z_][a-z0-9_]*)\2\]#i'
        ),
        array(
            '$1',
            '$1$2',
            '}',
            '$1$3',
            '$1.$3'
        ),
    $input);
}


function getDealerCountryCombo()
	{
		
			$sql = "select CountryId,CountryName from mstcountry where gulfcountry = 1 or africancountry = 1 order by CountryName asc limit 0,50";
			//$latestcomps -> obj1 = new CommonProc();
			//$eventlisting = $latestcomps->obj1->getResults('',$sql);
			$eventlisting = returnData($sql);
			if ($eventlisting)
			{	
				
				$rowcount = count($eventlisting);
				for($i=0;$i< $rowcount;$i++)
				{
					$compvalues .= '<option value="'.$eventlisting[$i]['CountryId']."-".strtoupper($eventlisting[$i]['CountryName']).'">'.strtoupper($eventlisting[$i]['CountryName']).'</option>';
				}
				return $compvalues;
			 }
		
	}

/* additional functions for B2B project such as price comparison, multiple products under one product category etc */
	function getProductsForComparison($maingroupid)
	{
		$todaysdate = date("Y-m-d");
		$lastmonth = date("Y-m-d H:i:s",mktime(0, 0, 0, date("m")-1, date("d"),   date("Y")));
		$limit = ' limit 0,24';
		if ($maingroupid!='')
		{
			$sql = " select groupid from
trncompanyprod a inner join mstproduct b on a.productid=b.productid where price > 1 and productimagefilepath > '' and b.maingroupid='$maingroupid' and b.groupid >0 group by b.groupid having count(b.groupid) > 2 $limit ";
			
			//$sql = "Select compprod, producttitle, productdesc, productimagefilepath,b.companyid from (Select max(CompanyProdID) as compprod from trncompanyprod where productimagefilepath > '' group by companyid) as a inner join trncompanyprod b on a.compprod = b.companyprodid inner join mstproduct c on b.productid=c.productid where c.maingroupid='$maingroupid' order by compprod desc $limit";
			//$sql1 = "Select compprod, producttitle, productdesc, productimagefilepath,b.companyid from (Select max(CompanyProdID) as compprod from trncompanyprod where productimagefilepath > '' and (productentereddate between '$lastmonth' and '$todaysdate'  or productlastmodifieddate between '$lastmonth' and '$todaysdate') group by companyid) as a inner join trncompanyprod b on a.compprod = b.companyprodid order by compprod desc $limit";
			//echo $sql;
			$sql1 = '';
		}
		$eventlisting1 = returnData($sql);
		$eventlisting1 = (!is_array($eventlisting1)?returnData($sql1):$eventlisting1);
		if ($eventlisting1)
		{
			$eventrowcount1 = count($eventlisting1);
			if ($eventrowcount1 > 0)
			{
				$productonoffer = '';
				for ($j=0;$j<$eventrowcount1;$j++)
				{
					$groupids .= ($groupids!='')?','.$eventlisting1[$j]['groupid']:$eventlisting1[$j]['groupid']; 
				}
					$sql2 = " select CompanyProdID as compprod, a.productid,a.companyid, productname,groupname,producttitle, productdesc, price, 
					pricecurrency,productimagefilepath,minorderqty,supplyability from trncompanyprod a inner join mstproduct b on a.productid=b.productid 
					inner join mstgroup d on d.groupid=b.groupid where price > 1 and productimagefilepath > '' and 
					b.groupid in ($groupids) group by a.productid ORDER BY groupname ";
					//echo $sql2;
					$eventlisting = returnData($sql2);
					$eventlisting = (!is_array($eventlisting)?returnData($sql1):$eventlisting);
					if ($eventlisting)
					{
						$eventrowcount = count($eventlisting);
						$groupname = $eventlisting[0]['groupname'];
						
						$EliteProductDetails = '<h3>'.$groupname.'</h3>';
						for ($i=0;$i<$eventrowcount;$i++)
						{	
							if ($groupname != $eventlisting[$i]['groupname'])
							{
								$groupname = $eventlisting[$i]['groupname'];
								$EliteProductDetails .= '</div><h3>'.$groupname.'</h3><div class="col-md-12 company-info">';
								
							}
						/*
						<li>
							<div class="sellbuyoffer"> <span class="offertopimage"><img src="images/1.png" height="40" width="40"/></span> <span><a href="#" class="mailseclinks">Lorem ipsum dolor ...20 june</a></span> </div>
						</li>
						<div class="col-md-4">
							<a href="#"><img src="images/pic4.png" alt="" class="img-responsive">
							<div class="col-md-12">
								<div>
									<div class="product-1">Waist Reducing Corset  </div>
									<div class="product-price">US $4.56</div>
								</div>
								<p class="product-specs">Min. Order: 100 Pieces<br>
								In Stock: 600<br>
								<button type="button" class="btn btn-danger">Enquiry</button>
								</p>
								
							</div>	
							</a>
						</div>			
						*/		
						$producttitle = preview_text(strip_tags($eventlisting[$i]['producttitle']),22);
						
						$CompanyProdID	  	= $eventlisting[$i]['compprod'];	
						$productlink 	  	= DOC_ROOT.'comprods/'.$CompanyProdID.'/'.str_replace('#45;','-',replaceForURL($producttitle)).'.htm';
						$productimagefilepath = strip_tags($eventlisting[$i]['productimagefilepath']);
						//$productdesc		= preview_text(ProperCase(strip_tags(str_replace('|',' ',$eventlisting[$i]['productdesc']))),130);	
						$productprice		= $eventlisting[$i]['pricecurrency'].' '.$eventlisting[$i]['price'];
						$minorderqty		= ($eventlisting[$i]['minorderqty']=='')?'1':$eventlisting[$i]['minorderqty'];
						$supplyability		= constant(SUPPLY_ABILITY_.$eventlisting[$i]['supplyability']);
						$priceunit			= ($eventlisting[$i]['priceunit']=='')?'Per Piece':$eventlisting[$i]['priceunit'];
						
						$EliteProductDetails .= '<div class="col-md-4 col-xs-12">';
						
						$EliteProductDetails .= '<a href="'.$productlink.'"><img src="'.COMPANY_PRODUCT_DIR.$productimagefilepath.'" class="img-responsive " alt="'.$producttitle.'" border="0" ></a>';
						
						$EliteProductDetails .= '<div class="col-md-12">';
						$EliteProductDetails .= '	<div>';
						$EliteProductDetails .= '		<div class="product-1"><a href="'.$productlink.'">'.strtoupper($producttitle).'</a></div>';
						$EliteProductDetails .= '		<div class="product-price">'.$productprice.'/-</div>';
						$EliteProductDetails .= '	</div>';
						
						$EliteProductDetails .= '<p class="product-specs">Min. Order: '.$minorderqty.'<br>';
						$EliteProductDetails .= 'In Stock: '.$supplyability.'<br>';
						// to do put up enquiry modal form here //
						$EliteProductDetails .= '<button type="button" class="btn btn-danger" data-toggle="modal" data-target="#SendEnquiryModal">Enquiry</button></p>';
						
						
						$EliteProductDetails .= '</div>';
						$EliteProductDetails .= '</div>';
						
						}
					}	
			}
			else
			{
				$EliteProductDetails = 'No Products found.';
			}
		}
	return $EliteProductDetails;
	}	

/* end of functions for b2b project */
		// this function is used to determine if same offer is posted by user on same date
		function checkSameOffer($offerbyuserid,$offertitle,$offerdesc,$offerdate)
		{
			$blnSameOfferExists = 0;
			$sql = "Select offerid from mstoffers where offerbyuserid='$offerbyuserid' and offertitle='$offertitle' and offerdesc='$offerdesc' and date(offerdate)='$offerdate'";
			$eventlisting1 = returnData($sql);
			if ($eventlisting1)
			{
				$eventrowcount1 = count($eventlisting1);
				if ($eventrowcount1 > 0)
				{
					$blnSameOfferExists =1;
				}
			}
			return $blnSameOfferExists;			
		}
		function detectMobile()
		{
			$mobiledevice = new Mobile_Detect();
			$retData = $mobiledevice->isMobile();
			echo '1';
			return $retData;
		}
		
		function CheckIfSelected($orgvalue,$value,$selectedtype)
		{
			if (($orgvalue!='')&&($value!='')&&($selectedtype!=''))
			{
				if ($orgvalue==$value)
				{
					return $selectedtype;
				}
				else
				{
					return '';
				}
			}
		}
		function getProductsCarousalForHomePage()
		{	
		$todaysdate = date("Y-m-d");
	
		$lastmonth = date("Y-m-d H:i:s",mktime(0, 0, 0, date("m")-1, date("d"),   date("Y")));
		//$sql = "Select compprod, producttitle, productimagefilepath,b.companyid from (Select max(CompanyProdID) as compprod from trncompanyprod where productimagefilepath > '' and (productentereddate between '$lastmonth' and '$todaysdate'  or productlastmodifieddate between '$lastmonth' and '$todaysdate') group by companyid) as a inner join trncompanyprod b on a.compprod = b.companyprodid order by compprod desc limit 0,8";
		$sql = "Select compprod, companyprodid, concat(productname,' in UAE') as prodtitle,producttitle,productname,groupname, productimagefilepath,b.companyid,price,c.validforecommerce from (Select CompanyProdID as compprod from trncompanyprod where productimagefilepath > ''  
		group by companyid ) as a inner join trncompanyprod b on a.compprod = b.companyprodid 
		inner join mstproduct c on b.productid=c.productid
		inner join mstgroup e on c.groupid=e.groupid
		inner join mstcompany f on f.companyid=b.companyid
		where f.countryid=19
		ORDER BY b.productlastmodifieddate desc,b.productentereddate desc";
		
		$latestcomps -> obj1 = new CommonProc();
		$productlisting = $latestcomps->obj1->getResults('',$sql);
	
		return $productlisting;
		//$latestcomps->obj1->disconnect_db()
	}		
		
		function getCarousalOnHomePage($groupname,$productlisting)	
		{
		if ($productlisting){
			$eventrowcount = (count($productlisting)>18)?18:count($productlisting);
		}
		else
		{
			$eventrowcount = 0;
		}	
		if ($eventrowcount > 0)
		{
			$productonoffer = '<div class="item active">
                  <ul class="thumbnails">';
			$j=0;			
		for ($i=0;$i<$eventrowcount;$i++)
		{				
			if ($groupname!='')
			{					
				if ($productlisting[$i]['groupname']==$groupname)
				{					
					if ((($j%6)==0)&&($j>0))
					{
					$productonoffer .= '	</ul>
											</div>
											<div class="item">
                  						<ul class="thumbnails">';					
					}					
					
					$producttitle = $productlisting[$i]['producttitle'];
					
					
					$CompanyProdID	  = $productlisting[$i]['compprod'];	
					$productlink 	  = DOC_ROOT.'comprods/'.$CompanyProdID.'/'.str_replace('#45;','-',replaceForURL($producttitle)).'.htm';
					$productimagefilepath = strip_tags($productlisting[$i]['productimagefilepath']);
					
					/*$type = pathinfo($path, PATHINFO_EXTENSION);
					$data = file_get_contents($path);
					$base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
					*/
					
					
					$productonoffer .= '<li class="col-md-2  col-lg-2  col-sm-3  col-xs-12">
                      <div class="thumbnail img-container-products"> 
                      <a href="'.$productlink.'"><img src="'.COMPANY_PRODUCT_DIR.$productlisting[$i]['productimagefilepath'].'" alt="'.$producttitle.'" border="0"></a> </div>
                      <div class="caption">
                        <h4 class="iUmrbN"><a href="'.$productlink.'">'.$producttitle.'</a></h4>
                        <div class="sale-up">Upto 35% Off</div>
                        <div class="flpas">&nbsp;</div>
                      </div>
              </li>';
					$j++;				
				}			
			}else 
			{				
				if ((($j%6)==0)&&($j>0))
					{
					$productonoffer .= '	</ul>
											</div>
											<div class="item">
                  						<ul class="thumbnails">';					
					}					
					
					$producttitle = preview_text($productlisting[$i]['producttitle'],40);
					
					
					$CompanyProdID	  = $productlisting[$i]['compprod'];	
					$productlink 	  = DOC_ROOT.'comprods/'.$CompanyProdID.'/'.str_replace('#45;','-',replaceForURL($producttitle)).'.htm';
					$productimagefilepath = strip_tags($productlisting[$i]['productimagefilepath']);
					
					$productonoffer .= '<li class="col-md-2  col-lg-2  col-sm-3  col-xs-12">
                      <div class="thumbnail img-container-products"> 
                      <a href="'.$productlink.'"><img src="'.COMPANY_PRODUCT_DIR.$productlisting[$i]['productimagefilepath'].'" alt="'.$producttitle.'" border="0"></a> </div>
                      <div class="caption">
                        <h4 class="iUmrbN"><a href="'.$productlink.'">'.$producttitle.'</a></h4>
                      </div>
              </li>';
					$j++;	
			}
		$productonoffer .= '	</ul>
											</div>';					
		}
	}
		return $productonoffer;
	}
	function compareBuyerSellerCountry($buyerCountry,$sellerCountryType,$sellerCountry)
	{
		$retval = 0;
		switch($sellerCountryType) 
		{
						
			case 'GCC':
				$gcccountryarray = array('United Arab Emirates','Saudi Arabia','Oman','Kuwait','Qatar','Bahrain');
				$buyercountryarray = array($buyerCountry);
				//print_r($buyercountryarray);
				$result=array_intersect($gcccountryarray,$buyercountryarray);
				//print_r($result);
				if(count($result)>0)
   			{
   				$retval = 1;	
    			}				
				break;			
			case 'Africa':
				$gcccountryarray = array('Algeria','Chad','Egypt','Ethiopia','Libya','Mali','Morocco','Nigeria','South Africa');
				$buyercountryarray = array($buyerCountry);
				//print_r($buyercountryarray);
				$result=array_intersect($gcccountryarray,$buyercountryarray);
				//print_r($result);
				if(count($result)>0)
   			{
   				$retval = 1;	
    			}				
				break;
			default:
				//$gcccountryarray = array($sellerCountry);
				//echo 'seller country '.$sellerCountry;
				//echo 'buyer country '.$buyerCountry;
				//echo strcmp(trim($sellerCountry),trim($buyerCountry));
            $retval = (strcmp(trim($sellerCountry),trim($buyerCountry))==0)?1:0;
				break;
				
				
		}
				
    		return $retval;				
	}	
	
	function to_utf8( $string ) { 
// From http://w3.org/International/questions/qa-forms-utf-8.html 
    if ( preg_match('%^(?: 
      [\x09\x0A\x0D\x20-\x7E]            # ASCII 
    | [\xC2-\xDF][\x80-\xBF]             # non-overlong 2-byte 
    | \xE0[\xA0-\xBF][\x80-\xBF]         # excluding overlongs 
    | [\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}  # straight 3-byte 
    | \xED[\x80-\x9F][\x80-\xBF]         # excluding surrogates 
    | \xF0[\x90-\xBF][\x80-\xBF]{2}      # planes 1-3 
    | [\xF1-\xF3][\x80-\xBF]{3}          # planes 4-15 
    | \xF4[\x80-\x8F][\x80-\xBF]{2}      # plane 16 
)*$%xs', $string) ) { 
        return $string; 
    } else { 
        return iconv( 'CP1252', 'UTF-8', $string); 
    } 
	} 

/**
 * Simple PHP Encryption functions
 *
 * Attempts to be as secure as possible given:
 *
 * - Key can be any string
 * - No knowledge of encryption is required
 * - Only key and raw/encrypted string is needed at each end
 * - Metadata can be anything (string, array, etc.)
 *
 * If possible, always prefer a library like https://github.com/defuse/php-encryption
 * and only use these functions if that isn't possible
 *
 * Adapted from http://stackoverflow.com/a/30239440/1562799
 */
/**
 * Encrypts a string
 *
 * @param string $key  Encryption key, also required for decryption
 * @param string $raw  Raw string to be encrypted
 * @param mixed  $meta Associated data that must be provided during decryption
 *
 * @return string Raw data encrypted with key
 */
function encrypt( $key, $plaintext, $meta = '' ) {
	// Generate valid key
	$key = hash_pbkdf2( 'sha256', $key, '', 10000, 0, true );
	// Serialize metadata
	$meta = serialize($meta);
	// Derive two subkeys from the original key
	$mac_key = hash_hmac( 'sha256', 'mac', $key, true );
	$enc_key = hash_hmac( 'sha256', 'enc', $key, true );
	$enc_key = substr( $enc_key, 0, 32 );
	// Derive a "synthetic IV" from the nonce, plaintext and metadata
	$temp = $nonce = ( 16 > 0 ? mcrypt_create_iv( 16 ) : "" );
	$temp .= hash_hmac( 'sha256', $plaintext, $mac_key, true );
	$temp .= hash_hmac( 'sha256', $meta, $mac_key, true );
	$mac = hash_hmac( 'sha256', $temp, $mac_key, true );
	$siv = substr( $mac, 0, 16 );
	// Encrypt the message
	$enc = mcrypt_encrypt( 'rijndael-128', $enc_key, $plaintext, 'ctr', $siv );
	return urlencode(base64_encode($siv.$nonce.$enc));
}
/**
 * Decrypts an encrypted string
 *
 * @param string $key       Encryption key, also used during encryption
 * @param string $encrypted Encrypted string to be decrypted
 * @param mixed  $meta      Associated data that must be the same as when encrypted
 *
 * @return string Decrypted string or `null` if key/meta has been tampered with
 */
function decrypt( $key, $ciphertext, $meta = '' ) {
	// Generate valid key
	$key = hash_pbkdf2( 'sha256', $key, '', 10000, 0, true );
	// Serialize metadata
	$meta = serialize($meta);
	// Derive two subkeys from the original key
	$mac_key = hash_hmac( 'sha256', 'mac', $key, true );
	$enc_key = hash_hmac( 'sha256', 'enc', $key, true );
	$enc_key = substr( $enc_key, 0, 32 );
	// Unpack MAC, nonce and encrypted message from the ciphertext
	$enc =base64_decode(urldecode($ciphertext));
	$siv = substr( $enc, 0, 16 );
	$nonce = substr( $enc, 16, 16 );
	$enc = substr( $enc, 16 + 16 );
	// Decrypt message
	$plaintext = mcrypt_decrypt( 'rijndael-128', $enc_key, $enc, 'ctr', $siv );
	// Verify MAC, return null if message is invalid
	$temp = $nonce;
	$temp .= hash_hmac( 'sha256', $plaintext, $mac_key, true );
	$temp .= hash_hmac( 'sha256', $meta, $mac_key, true );
	$mac = hash_hmac( 'sha256', $temp, $mac_key, true );
	if ( $siv !== substr( $mac, 0, 16 ) ) return null;
	return $plaintext;
}

function getBrandsForHomePage()
{
	$sql = "SELECT brandname,brandimage,count(a.brandid)as brandcount FROM mstbrands a INNER JOIN trncompanyprod b on a.brandid=b.brandid GROUP BY a.brandid HAVING count(a.brandid)>50 order by brandcount desc limit 0,20";
	$eventlisting1 = returnData($sql);
	if ($eventlisting1)
	{
		$eventrowcount1 = count($eventlisting1);
		if ($eventrowcount1 > 0)
		{
			for($i=0;$i<$eventrowcount1;$i++) 
			{
				$brandname = $eventlisting1[$i]['brandname'];
				$brandimage = "https://1915908331.rsc.cdn77.org/userdata/companylogo/brands/".$eventlisting1[$i]['brandimage'];
					
				$brandstr .= '<div class="col-md-3">
								<div class=" brand-img">
									<a href="'.DOC_ROOT.'brand/'.replaceForURL($brandname).'.htm"><img src="'.$brandimage.'" alt="'.$brandname.'"></a>
								</div>
							</div>';
			}					
		}
	}
	return $brandstr;		
}

?>